// ==UserScript==
// @name         HV 彩虹小马 (My Little Pony)
// @namespace    http://tampermonkey.net/
// @version      0.6
// @description  验证码助手 (Hentaiverse verification helper)
// @author       ssnangua_cn
// @match        *://hentaiverse.org/*s=Battle*
// @match        *://alt.hentaiverse.org/*s=Battle*
// @match        *://127.0.0.1:5500/The%20HentaiVerse.html
// @icon         https://hentaiverse.org/y/favicon.png
// @grant        none
// @license      MIT
// @downloadURL https://update.sleazyfork.org/scripts/459603/HV%20%E5%BD%A9%E8%99%B9%E5%B0%8F%E9%A9%AC%20%28My%20Little%20Pony%29.user.js
// @updateURL https://update.sleazyfork.org/scripts/459603/HV%20%E5%BD%A9%E8%99%B9%E5%B0%8F%E9%A9%AC%20%28My%20Little%20Pony%29.meta.js
// ==/UserScript==

(async function () {
  "use strict";

  const $ = (s) => document.querySelector(s);
  const $$ = (s) => Array.from(document.querySelectorAll(s));

  const img = $("#riddleimage>img");
  if (!img) return;

  if (!img.complete) {
    await new Promise((resolve) => (img.onload = resolve));
  }

  // === 拖动 ===
  function dragger(el) {
    el.onmousedown = (e) => {
      const drag = {
        el_x: el.offsetLeft,
        el_y: el.offsetTop,
        mouse_x: e.x,
        mouse_y: e.y,
      };
      window.onmousemove = (e) => {
        el.style.left = drag.el_x + e.x - drag.mouse_x + "px";
        el.style.top = drag.el_y + e.y - drag.mouse_y + "px";
      };
      window.onmouseup = () => {
        window.onmousemove = null;
        window.onmouseup = null;
      };
    };
  }

  const bound = img.getBoundingClientRect();
  img.style.width = bound.width + "px";
  img.style.height = bound.height + "px";
  img.style.left = bound.x + "px";
  img.style.top = bound.y + "px";

  // === 注入样式 ===
  const style = document.createElement("style");
  style.innerHTML = `
    * {
      user-select: none;
    }
    #csp {
      height: 800px;
    }
    #mainpane {
      height: 800px;
    }
    #riddleimage {
      position: relative;
      z-index: 0;
    }
    #riddlemid {
      position: relative;
      z-index: 100;
    }
    #riddleimage>img {
      position: fixed;
      -webkit-user-drag: none;
    }
    #riddler1 label {
      height: initial;
      white-space: nowrap;
    }
    #mlp_pane {
      z-index: 200;
      position: fixed;
      top: 20px;
      left: 20px;
      padding: 20px;
      background: #dcd3b7;
      border: 2px solid #5C0D11;
      border-radius: 5px;
      cursor: move;
    }
    #mlp_box {
      width: 200px;
      cursor: default;
    }
  `;
  document.head.appendChild(style);

  // === 图片占位节点 ===
  const placeholder = document.createElement("div");
  placeholder.style.cssText = `width: ${img.offsetWidth}px; height: ${img.offsetHeight}px`;
  img.parentNode.appendChild(placeholder);

  // === 图片拖动 ===
  dragger(img);

  const data = { scale: 1, rotate: 0, contrast: 1.2, unsharp: 10 };

  // === 面板 ===
  const pane = document.createElement("div");
  pane.id = "mlp_pane";
  pane.innerHTML = `<div id="mlp_box">
    <div>旋　转：<input id="rotate" type="range" min="-180" max="180" step="1" value="${data.rotate}"></div>
    <div>对比度：<input id="contrast" type="range" min="1" max="2" step="0.1" value="${data.contrast}"></div>
    <div>锐　化：<input id="unsharp" type="range" min="0" max="50" step="0.1" value="${data.unsharp}"></div>
    <div style="margin-top: 10px">验证图按下可拖动 / 滚轮可缩放</div>
  </div>`;
  document.body.appendChild(pane);
  pane.style.left =
    Math.min(
      $("#csp").offsetWidth + 20,
      window.innerWidth - pane.offsetWidth - 20
    ) + "px";

  // === 面板拖动 ===
  dragger(pane);
  $("#mlp_box").onmousedown = (e) => e.stopPropagation();

  // === svg锐化滤镜 ===
  const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
  svg.innerHTML = `
    <defs>
      <filter id="unsharpy">
        <feGaussianBlur result="blurOut" in="SourceGraphic" stdDeviation="${data.unsharp}" />
        <feComposite operator="arithmetic" k1="0" k2="1.3" k3="-0.3" k4="0" in="SourceGraphic" in2="blurOut" />
      </filter>
    </defs>
  `;
  document.body.appendChild(svg);

  // === 图片处理 ===
  const unsharpy = $("#unsharpy>feGaussianBlur");
  function updateImg() {
    unsharpy.setAttribute("stdDeviation", data.unsharp);
    img.style.filter = `contrast(${data.contrast}) url(#unsharpy)`;
    img.style.transform = `rotate(${data.rotate}deg) scale(${data.scale})`;
  }
  updateImg();

  pane.onmousewheel = img.onmousewheel = (e) => {
    data.scale = Math.max(0.1, data.scale + (e.deltaY > 0 ? -0.1 : 0.1));
    updateImg();
    e.preventDefault();
  };
  ["rotate", "contrast", "unsharp"].forEach((k) => {
    $("#" + k).oninput = function () {
      data[k] = this.value;
      updateImg();
    };
  });

  // === 小马图片 ===
  const images = {
    "Twilight Sparkle":
      "data:image/png;base64,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",
    Rarity:
      "data:image/png;base64,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",
    Fluttershy:
      "data:image/png;base64,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",
    "Rainbow Dash":
      "data:image/png;base64,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",
    "Pinkie Pie":
      "data:image/png;base64,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",
    Applejack:
      "data:image/png;base64,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",
  };
  $$("#riddler1 label").forEach((el) => {
    const div = document.createElement("div");
    div.innerHTML = `<img src="${
      images[el.innerText]
    }" style="max-width: 96px; max-height: 96px">`;
    el.appendChild(div);
  });
})();
